/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Shark
**
** DESCRIPTION:	Manages sharks
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SHARK_H
#define SHARK_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Shark_c_iMaxSharks = 6;
const int Shark_c_iChanceOfNotSwimmingOffTheMap = 80;
const int Shark_c_iChanceOfVaryingDirection = 10;
const float Shark_c_fSpeed = 0.03f;
const float Shark_c_fTurnaroundSpeed = 0.25f;
const float Shark_c_fDirectionVariationSpeed = 0.01f;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CShark
{
private:

	//class enumerations
	enum EFrame
	{
		eFrame_NorthEast = 0,
		eFrame_East,
		eFrame_SouthEast,
		eFrame_South,
		eFrame_SouthWest,
		eFrame_West,
		eFrame_NorthWest,
		eFrame_North,
	};

	//class structures
	struct SInst
	{
		friend class CShark;

	private:

		//structure data
		bool		m_bIsActive;
		bool		m_bIsTurningBack;
		ldwPoint	m_sPos;
		ldwPoint	m_sVel;
		float		m_fAngularVel;

		//structure methods
	};

	friend struct SInst;

	//class data
	SInst			m_InstArray[Shark_c_iMaxSharks];
	ldwImageGrid *	m_pSharkAnim;

	//class methods
	//setup
	public:		CShark(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	// process
	public:		const bool Create(const ldwPoint sPos/*, const EDirection eDirection*/);
	public:		void Update();
	public:		void Draw() const;
	public:		void Draw(const int iShark) const;

	// access
	public:		const int GetNumberOfSharksNearby(const ldwPoint sPos, const int iSearchRadius) const;
	public:		const int GetNumberOfSharks() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CShark		Shark;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/